//
//  MCHostMonitor.h
//  OfflineSyncClient
//
//  Created by Brent Gulanowski on 09-09-16.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//


#import <Foundation/Foundation.h>


@class MCHostMonitor;

@protocol MCHostMonitorDelegate <NSObject>

@optional
- (void)hostMonitor:(MCHostMonitor *)monitor hostIsLocal:(BOOL)flag;
- (void)hostMonitor:(MCHostMonitor *)monitor hostIsDirect:(BOOL)flag;
- (void)hostMonitor:(MCHostMonitor *)monitor hostIsReachable:(BOOL)flag;

@end


@class MCReachability;

@interface MCHostMonitor : NSObject {

	id<MCHostMonitorDelegate> delegate;
	MCReachability *reachability;
	
	BOOL watchLocal;
	BOOL watchDirect;
	BOOL watchReachable;
}

@property (nonatomic, assign) id<MCHostMonitorDelegate> delegate;
@property (nonatomic, retain) MCReachability *reachability;

- (id)initWithReachability:(MCReachability *)reach;

+ (void)addDirectHost:(NSString *)host;
+ (void)removeDirectHost:(NSString *)host;

//+ (void)configureOfflineClientAgent;

@end
